#ifndef _MCP2510_registerS_H_
#define _MCP2510_registerS_H_

//@@MCP 2510 registers
// <GROUP !!CONSTANTS>
// Description
//		MCP 2510 registers

#define RXF0SIDH	0x00	//@@ <GROUP MCP 2510 registers> Acceptance filter 0 standard identifier high
#define RXF0SIDL	0x01	//@@ <GROUP MCP 2510 registers> Acceptance filter 0 standard identifier low
#define RXF0EID8	0x02	//@@ <GROUP MCP 2510 registers> Acceptance filter 0 extended identifier high
#define RXF0EID0	0x03	//@@ <GROUP MCP 2510 registers> Acceptance filter 0 extended identifier low
#define RXF1SIDH	0x04	//@@ <GROUP MCP 2510 registers> Acceptance filter 1 standard identifier high
#define RXF1SIDL	0x05	//@@ <GROUP MCP 2510 registers> Acceptance filter 1 standard identifier low
#define RXF1EID8	0x06	//@@ <GROUP MCP 2510 registers> Acceptance filter 1 extended identifier high
#define RXF1EID0	0x07	//@@ <GROUP MCP 2510 registers> Acceptance filter 1 extended identifier low	
#define RXF2SIDH	0x08	//@@ <GROUP MCP 2510 registers> Acceptance filter 2 standard identifier high
#define RXF2SIDL	0x09	//@@ <GROUP MCP 2510 registers> Acceptance filter 2 standard identifier low
#define RXF2EID8	0x0A	//@@ <GROUP MCP 2510 registers> Acceptance filter 2 extended identifier high
#define RXF2EID0	0x0B	//@@ <GROUP MCP 2510 registers> Acceptance filter 2 extended identifier low	
#define BFPCTRL		0x0C	//@@ <GROUP MCP 2510 registers> Pin control and status register
#define TXRTSCTRL	0x0D	//@@ <GROUP MCP 2510 registers> Pin control and status register
#define CANSTAT		0x0E	//@@ <GROUP MCP 2510 registers> CAN status register
#define CANCTRL		0x0F	//@@ <GROUP MCP 2510 registers>	CAN control register

#define RXF3SIDH	0x10	//@@ <GROUP MCP 2510 registers> Acceptance filter 3 standard identifier high
#define RXF3SIDL	0x11	//@@ <GROUP MCP 2510 registers> Acceptance filter 3 standard identifier low
#define RXF3EID8	0x12	//@@ <GROUP MCP 2510 registers> Acceptance filter 3 extended identifier high
#define RXF3EID0	0x13	//@@ <GROUP MCP 2510 registers> Acceptance filter 3 extended identifier low
#define RXF4SIDH	0x14	//@@ <GROUP MCP 2510 registers> Acceptance filter 4 standard identifier high
#define RXF4SIDL	0x15	//@@ <GROUP MCP 2510 registers> Acceptance filter 4 standard identifier low
#define RXF4EID8	0x16	//@@ <GROUP MCP 2510 registers> Acceptance filter 4 extended identifier high
#define RXF4EID0	0x17	//@@ <GROUP MCP 2510 registers> Acceptance filter 4 extended identifier low
#define RXF5SIDH	0x18	//@@ <GROUP MCP 2510 registers> Acceptance filter 5 standard identifier high
#define RXF5SIDL	0x19	//@@ <GROUP MCP 2510 registers> Acceptance filter 5 standard identifier low
#define RXF5EID8	0x1A	//@@ <GROUP MCP 2510 registers> Acceptance filter 5 extended identifier high
#define RXF5EID0	0x1B	//@@ <GROUP MCP 2510 registers> Acceptance filter 5 extended identifier low
#define TEC			0x1C	//@@ <GROUP MCP 2510 registers> Transmit error counter
#define REC			0x1D	//@@ <GROUP MCP 2510 registers> Receive error counter

#define RXM0SIDH	0x20	//@@ <GROUP MCP 2510 registers> Acceptance mask 0 standard identifier high
#define RXM0SIDL	0x21	//@@ <GROUP MCP 2510 registers> Acceptance mask 0 standard identifier low
#define RXM0EID8	0x22	//@@ <GROUP MCP 2510 registers> Acceptance mask 0 extended identifier high
#define RXM0EID0	0x23	//@@ <GROUP MCP 2510 registers> Acceptance mask 0 extended identifier low
#define RXM1SIDH	0x24	//@@ <GROUP MCP 2510 registers> Acceptance mask 1 standard identifier high
#define RXM1SIDL	0x25	//@@ <GROUP MCP 2510 registers> Acceptance mask 1 standard identifier low
#define RXM1EID8	0x26	//@@ <GROUP MCP 2510 registers> Acceptance mask 1 extended identifier high
#define RXM1EID0	0x27	//@@ <GROUP MCP 2510 registers> Acceptance mask 1 extended identifier low
#define CNF3		0x28	//@@ <GROUP MCP 2510 registers> Bit timing configuration register 3
#define CNF2		0x29	//@@ <GROUP MCP 2510 registers> Bit timing configuration register 2
#define CNF1		0x2A	//@@ <GROUP MCP 2510 registers> Bit timing configuration register 1
#define CANINTE		0x2B	//@@ <GROUP MCP 2510 registers> Interrupt enable register	
#define CANINTF		0x2C	//@@ <GROUP MCP 2510 registers> Interrupt flag register	
#define EFLG		0x2D	//@@ <GROUP MCP 2510 registers> Error flag register	

#define TXB0CTRL	0x30	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 control register
#define TXB0SIDH	0x31	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 standard identifier high
#define TXB0SIDL	0x32	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 standard identifier low	
#define TXB0EID8	0x33	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 extended identifier high	
#define TXB0EID0	0x34	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 extended identifier low
#define TXB0DLC		0x35	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data length code
#define TXB0D0		0x36	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data field byte 0
#define TXB0D1		0x37	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data field byte 1
#define TXB0D2		0x38	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data field byte 2
#define TXB0D3		0x39	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data field byte 3
#define TXB0D4		0x3A	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data field byte 4
#define TXB0D5		0x3B	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data field byte 5
#define TXB0D6		0x3C	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data field byte 6
#define TXB0D7		0x3D	//@@ <GROUP MCP 2510 registers> Transmit buffer 0 data field byte 7

#define TXB1CTRL	0x40	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 control register
#define TXB1SIDH	0x41	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 standard identifier high
#define TXB1SIDL	0x42	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 standard identifier low	
#define TXB1EID8	0x43	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 extended identifier high	
#define TXB1EID0	0x44	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 extended identifier low
#define TXB1DLC		0x45	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data length code
#define TXB1D0		0x46	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data field byte 0
#define TXB1D1		0x47	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data field byte 1
#define TXB1D2		0x48	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data field byte 2
#define TXB1D3		0x49	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data field byte 3
#define TXB1D4		0x4A	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data field byte 4
#define TXB1D5		0x4B	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data field byte 5
#define TXB1D6		0x4C	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data field byte 6
#define TXB1D7		0x4D	//@@ <GROUP MCP 2510 registers> Transmit buffer 1 data field byte 7

#define TXB2CTRL	0x50	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 control register
#define TXB2SIDH	0x51	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 standard identifier high
#define TXB2SIDL	0x52	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 standard identifier low	
#define TXB2EID8	0x53	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 extended identifier high	
#define TXB2EID0	0x54	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 extended identifier low
#define TXB2DLC		0x55	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data length code
#define TXB2D0		0x56	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data field byte 0
#define TXB2D1		0x57	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data field byte 1
#define TXB2D2		0x58	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data field byte 2
#define TXB2D3		0x59	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data field byte 3
#define TXB2D4		0x5A	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data field byte 4
#define TXB2D5		0x5B	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data field byte 5
#define TXB2D6		0x5C	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data field byte 6
#define TXB2D7		0x5D	//@@ <GROUP MCP 2510 registers> Transmit buffer 2 data field byte 7

#define RXB0CTRL	0x60	//@@ <GROUP MCP 2510 registers> Receive buffer 0 control register
#define RXB0SIDH	0x61	//@@ <GROUP MCP 2510 registers> Receive buffer 0 standard identifier high
#define RXB0SIDL	0x62	//@@ <GROUP MCP 2510 registers> Receive buffer 0 standard identifier low
#define RXB0EID8	0x63	//@@ <GROUP MCP 2510 registers> Receive buffer 0 extended identifier high
#define RXB0EID0	0x64	//@@ <GROUP MCP 2510 registers> Receive buffer 0 extended identifier low
#define RXB0DLC		0x65	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data length code
#define RXB0D0		0x66	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data field byte 0
#define RXB0D1		0x67	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data field byte 1
#define RXB0D2		0x68	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data field byte 2
#define RXB0D3		0x69	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data field byte 3
#define RXB0D4		0x6A	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data field byte 4
#define RXB0D5		0x6B	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data field byte 5
#define RXB0D6		0x6C	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data field byte 6
#define RXB0D7		0x6D	//@@ <GROUP MCP 2510 registers> Receive buffer 0 data field byte 7

#define RXB1CTRL	0x70	//@@ <GROUP MCP 2510 registers> Receive buffer 1 control register
#define RXB1SIDH	0x71	//@@ <GROUP MCP 2510 registers> Receive buffer 1 standard identifier high
#define RXB1SIDL	0x72	//@@ <GROUP MCP 2510 registers> Receive buffer 1 standard identifier low
#define RXB1EID8	0x73	//@@ <GROUP MCP 2510 registers> Receive buffer 1 extended identifier high
#define RXB1EID0	0x74	//@@ <GROUP MCP 2510 registers> Receive buffer 1 extended identifier low
#define RXB1DLC		0x75	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data length code
#define RXB1D0		0x76	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data field byte 0
#define RXB1D1		0x77	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data field byte 1
#define RXB1D2		0x78	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data field byte 2
#define RXB1D3		0x79	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data field byte 3
#define RXB1D4		0x7A	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data field byte 4
#define RXB1D5		0x7B	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data field byte 5
#define RXB1D6		0x7C	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data field byte 6
#define RXB1D7		0x7D	//@@ <GROUP MCP 2510 registers> Receive buffer 1 data field byte 7


//@@MCP 2510 BFPCTRL register
// <GROUP !!CONSTANTS>
// Description
//		Bit mask for pin control and status register BFPCTRL
#define B1BFS		5	//@@ <GROUP MCP 2510 BFPCTRL register> RX1BF pin state
#define B0BFS		4	//@@ <GROUP MCP 2510 BFPCTRL register> RX0BF pin state
#define B1BFE		3	//@@ <GROUP MCP 2510 BFPCTRL register> RX1BF pin function enable
#define B0BFE		2	//@@ <GROUP MCP 2510 BFPCTRL register> RX0BF pin function enable
#define B1BFM		1	//@@ <GROUP MCP 2510 BFPCTRL register> RX1BF pin operation mode
#define B0BFM		0	//@@ <GROUP MCP 2510 BFPCTRL register> RX0BF pin operation mode


//@@MCP 2510 TXRTSCTRL register
// <GROUP !!CONSTANTS>
// Description
//		Bit mask for pin control and status register TXRTSCTRL
#define B2RTS		5	//@@ <GROUP MCP 2510 TXRTSCTRL register> TX2RTS pin state
#define B1RTS		4	//@@ <GROUP MCP 2510 TXRTSCTRL register> TX1RTS pin state
#define B0RTS		3	//@@ <GROUP MCP 2510 TXRTSCTRL register> TX0RTS pin state
#define B2RTSM		2	//@@ <GROUP MCP 2510 TXRTSCTRL register> TX2RTS pin mode
#define B1RTSM		1	//@@ <GROUP MCP 2510 TXRTSCTRL register> TX1RTS pin mode
#define B0RTSM		0	//@@ <GROUP MCP 2510 TXRTSCTRL register> TX0RTS pin mode

//@@MCP 2510 CANSTAT register
// <GROUP !!CONSTANTS>
// Description
//		CAN status register CANSTAT					<P>
//													<P>				
//		OPMOD:										<P>
//		000 = Device is in normal operation mode	<P>
//		001	= Device is in sleep mode				<P>
//		010 = Device is in loopback mode			<P>
//		011 = Device is in listen only mode			<P>
//		100 = Device is in configuration mode		<P>
//													<P>
//		ICOD: 										<P>
//		000 = No interrupt							<P>
//		001 = Error interrupt						<P>
//		010	= Wake-up interrupt						<P>
//		011 = TXB0 interrupt						<P>
//		100 = TXB1 interrupt						<P>
//		101 = TXB2 interrupt						<P>
//		110 = RXB0 interrupt						<P>
//		111 = RXB1 interrupt						<P>
//
#define OPMOD2		7	//@@ <GROUP MCP 2510 CANSTAT register> Operation mode
#define OPMOD1		6	//@@ <GROUP MCP 2510 CANSTAT register> Operation mode
#define OPMOD0		5	//@@ <GROUP MCP 2510 CANSTAT register> Operation mode
#define ICOD2		3	//@@ <GROUP MCP 2510 CANSTAT register> Interrupt flag
#define ICOD1		2	//@@ <GROUP MCP 2510 CANSTAT register> Interrupt flag
#define ICOD0		1	//@@ <GROUP MCP 2510 CANSTAT register> Interrupt flag

//@@MCP 2510 CANCTRL register
// <GROUP !!CONSTANTS>
// Description
//		CAN control register CANCTRL		<P>
//		REQOP:								<P>
//		000 = Set normal operation mode		<P>
//		001	= Set Sleep mode				<P>
//		010	= Set loopback mode				<P>
//		011 = Set listen only mode			<P>
//		100 = Set configuration mode		<P>
//
#define REQOP2		7	//@@ <GROUP MCP 2510 CANCTRL register> Request operation mode
#define REQOP1		6	//@@ <GROUP MCP 2510 CANCTRL register> Request operation mode
#define REQOP0		5	//@@ <GROUP MCP 2510 CANCTRL register> Request operation mode
#define ABAT		4	//@@ <GROUP MCP 2510 CANCTRL register> Abort all pending transmission
#define CLKEN		2	//@@ <GROUP MCP 2510 CANCTRL register> CLKOUT pin enable
#define CLKPRE1		1	//@@ <GROUP MCP 2510 CANCTRL register> CLKOUT pin prescaler
#define CLKPRE0		0	//@@ <GROUP MCP 2510 CANCTRL register> CLKOUT pin prescaler

//@@MCP 2510 CNF3 register
// <GROUP !!CONSTANTS>
// Description
//		Bit timing configuration register 3
#define WAKFIL		6	//@@ <GROUP MCP 2510 CNF3 register> Enable/disable wake-up filter
#define PHSEG22		2	//@@ <GROUP MCP 2510 CNF3 register> Phase segment 2 length
#define PHSEG21		1	//@@ <GROUP MCP 2510 CNF3 register> Phase segment 2 length
#define PHSEG20		0	//@@ <GROUP MCP 2510 CNF3 register> Phase segment 2 length

//@@MCP 2510 CNF2 register
// <GROUP !!CONSTANTS>
// Description
//		Bit timing configuration register 2
#define BTLMODE		7	//@@ <GROUP MCP 2510 CNF2 register> Phase segment 2 bit time length
#define SAM			6	//@@ <GROUP MCP 2510 CNF2 register> Sample point configuration
#define PHSEG12		5	//@@ <GROUP MCP 2510 CNF2 register> Phase segment 1 length
#define PHSEG11		4	//@@ <GROUP MCP 2510 CNF2 register> Phase segment 1 length
#define PHSEG10		3	//@@ <GROUP MCP 2510 CNF2 register> Phase segment 1 length
#define PHSEG2		2	//@@ <GROUP MCP 2510 CNF2 register> Propagation segment length
#define PHSEG1		1	//@@ <GROUP MCP 2510 CNF2 register> Propagation segment length
#define PHSEG0		0	//@@ <GROUP MCP 2510 CNF2 register> Propagation segment length

//@@MCP 2510 CNF1 register
// <GROUP !!CONSTANTS>
// Description
//		Bit timing configuration register 1		<P>
//		111111 = Tq = 2x64x1/Fosc				<P>
//		..										<P>
//		..										<P>
//		000000 = Tq = 2x1x1/Fosc				<P>
//
#define SJW1		7	//@@ <GROUP MCP 2510 CNF1 register> Synchronization jump width length
#define SJW0		6	//@@ <GROUP MCP 2510 CNF1 register> Synchronization jump width length
#define BRP5		5	//@@ <GROUP MCP 2510 CNF1 register> Baud-rate prescaler
#define BRP4		4	//@@ <GROUP MCP 2510 CNF1 register> Baud-rate prescaler
#define BRP3		3	//@@ <GROUP MCP 2510 CNF1 register> Baud-rate prescaler
#define BRP2		2	//@@ <GROUP MCP 2510 CNF1 register> Baud-rate prescaler
#define BRP1		1	//@@ <GROUP MCP 2510 CNF1 register> Baud-rate prescaler
#define BRP0		0	//@@ <GROUP MCP 2510 CNF1 register> Baud-rate prescaler

//@@MCP 2510 CANINTE register
// <GROUP !!CONSTANTS>
// Description
//		Interrupt enable register
#define MERRE		7	//@@ <GROUP MCP 2510 CANINTE register> Message error interrupt enable
#define WAKIE		6	//@@ <GROUP MCP 2510 CANINTE register> Wake-up interrupt enable
#define ERRIE		5	//@@ <GROUP MCP 2510 CANINTE register> Error interrupt enable
#define TX2IE		4	//@@ <GROUP MCP 2510 CANINTE register> Transmit buffer 2 empty interrupt enable
#define TX1IE		3	//@@ <GROUP MCP 2510 CANINTE register> Transmit buffer 1 empty interrupt enable
#define TX0IE		2	//@@ <GROUP MCP 2510 CANINTE register> Transmit buffer 0 empty interrupt enable
#define RX1IE		1	//@@ <GROUP MCP 2510 CANINTE register> Receive buffer 1 full interrupt enable
#define RX0IE		0	//@@ <GROUP MCP 2510 CANINTE register> Receive buffer 0 full interrupt enable

//@@MCP 2510 CANINTF register
// <GROUP !!CONSTANTS>
// Description
//		Interrupt flag register
#define MERRF		7	//@@ <GROUP MCP 2510 CANINTF register> Message error interrupt flag
#define WAKIF		6	//@@ <GROUP MCP 2510 CANINTF register> Wake-up interrupt flag
#define ERRIF		5	//@@ <GROUP MCP 2510 CANINTF register> Error interrupt flag
#define TX2IF		4	//@@ <GROUP MCP 2510 CANINTF register> Transmit buffer 2 empty interrupt flag
#define TX1IF		3	//@@ <GROUP MCP 2510 CANINTF register> Transmit buffer 1 empty interrupt flag
#define TX0IF		2	//@@ <GROUP MCP 2510 CANINTF register> Transmit buffer 0 empty interrupt flag
#define RX1IF		1	//@@ <GROUP MCP 2510 CANINTE register> Receive buffer 1 full interrupt flag
#define RX0IF		0	//@@ <GROUP MCP 2510 CANINTE register> Receive buffer 0 full interrupt flag

//@@MCP 2510 EFLG register
// <GROUP !!CONSTANTS>
// Description
//		Error flag register
#define RX1OVR		7	//@@ <GROUP MCP 2510 EFLG register> Receive buffer 1 overflow flag
#define RX0OVR		6	//@@ <GROUP MCP 2510 EFLG register> Receive buffer 1 overflow flag
#define TXBO		5	//@@ <GROUP MCP 2510 EFLG register> Bus-off error flag
#define TXEP		4	//@@ <GROUP MCP 2510 EFLG register> Transmit error-passive flag
#define RXEP		3	//@@ <GROUP MCP 2510 EFLG register> Receive error-passive flag
#define TXWAR		2	//@@ <GROUP MCP 2510 EFLG register> Transmit error warning flag
#define RXWAR		1	//@@ <GROUP MCP 2510 EFLG register> Receive error warning flag
#define EWARN		0	//@@ <GROUP MCP 2510 EFLG register> Error warning flag

//@@MCP 2510 TXBnCTRL registers
// <GROUP !!CONSTANTS>
// Description
//		Transmit buffer control registers		<P>
//		TXPx:									<P>
//		11 = Highest message priority			<P>
//		10 = High intermediate message priority	<P>
//		01 = Low  intermediate message priority	<P>
//		00 = Lowest message priority			<P>
//		
#define ABTF		6	//@@ <GROUP MCP 2510 TXBnCTRL registers> Message aborted flag
#define MLOA		5	//@@ <GROUP MCP 2510 TXBnCTRL registers> Message lost arbitration
#define TXERR		4	//@@ <GROUP MCP 2510 TXBnCTRL registers> Transmission error detected
#define TXREQ		3	//@@ <GROUP MCP 2510 TXBnCTRL registers> Message transmit request
#define TXP1		1	//@@ <GROUP MCP 2510 TXBnCTRL registers> Transmit Buffer priority
#define TXP0		0	//@@ <GROUP MCP 2510 TXBnCTRL registers> Transmit Buffer priority

//@@MCP 2510 RXB0CTRL register
// <GROUP !!CONSTANTS>
// Description
//		Receive buffer control register
//
#define RXM1		6	//@@ <GROUP MCP 2510 RXB0CTRL register>	Receive Buffer operating mode
#define RXM0		5	//@@ <GROUP MCP 2510 RXB0CTRL register>	Receive Buffer operating mode
#define RXRTR		3	//@@ <GROUP MCP 2510 RXB0CTRL register>	Received remote transfer request
#define BUKT		2	//@@ <GROUP MCP 2510 RXB0CTRL register>	Rellover enable
#define BUKT1		1	//@@ <GROUP MCP 2510 RXB0CTRL register>	Read only vopy of BUKT

//@@MCP 2510 RXB1CTRL register
// <GROUP !!CONSTANTS>
// Description
//		Receive buffer control register
//
#define FILHIT2		2	//@@ <GROUP MCP 2510 RXB1CTRL register>	Filter hit 
#define FILHIT1		1	//@@ <GROUP MCP 2510 RXB1CTRL register>	Filter hit
#define FILHIT0		0	//@@ <GROUP MCP 2510 RXB1CTRL register>	Filter hit

//@@MCP 2510 SJW
// <GROUP !!CONSTANTS>
// Description
//		Synchronization jump width length
//
#define SJW_1TQ         0x00	//@@ <GROUP MCP 2510 SJW> 1 x Tq
#define SJW_2TQ         0x40	//@@ <GROUP MCP 2510 SJW> 2 x Tq
#define SJW_3TQ         0x80	//@@ <GROUP MCP 2510 SJW> 3 x Tq
#define SJW_4TQ         0xC0	//@@ <GROUP MCP 2510 SJW> 4 x Tq

//@@MCP 2510 BTLMODE
// <GROUP !!CONSTANTS>
// Description
//		Phase segment 2 bit time length
//		
#define BTLMODE_CNF3    0x80	//@@ <GROUP MCP 2510 BTLMODE> Length of phase seg 2 determined by PHSEG2x bits of CNF3
#define BTLMODE_PH1_IPT 0x00	//@@ <GROUP MCP 2510 BTLMODE> Length of phase seg 2 is the greater of phase seg

//@@MCP 2510 SMPL
// <GROUP !!CONSTANTS>
// Description
//		Sample point configuration
//		
#define SMPL_3X         0x40	//@@ <GROUP MCP 2510 SMPL> Bus line is sampled three at the sample point
#define SMPL_1X         0x00	//@@ <GROUP MCP 2510 SMPL> Bus line is sampled at the sample point

//@@MCP 2510 PHSEG1
// <GROUP !!CONSTANTS>
// Description
//		Phase segment 1 length
//
#define PHSEG1_8TQ      0x38	//@@ <GROUP MCP 2510 PHSEG1> 8xTq 
#define PHSEG1_7TQ      0x30	//@@ <GROUP MCP 2510 PHSEG1> 7xTq
#define PHSEG1_6TQ      0x28	//@@ <GROUP MCP 2510 PHSEG1> 6xTq
#define PHSEG1_5TQ      0x20	//@@ <GROUP MCP 2510 PHSEG1> 5xTq
#define PHSEG1_4TQ      0x18	//@@ <GROUP MCP 2510 PHSEG1> 4xTq
#define PHSEG1_3TQ      0x10	//@@ <GROUP MCP 2510 PHSEG1> 3xTq
#define PHSEG1_2TQ      0x08	//@@ <GROUP MCP 2510 PHSEG1> 2xTq
#define PHSEG1_1TQ      0x00	//@@ <GROUP MCP 2510 PHSEG1> 1xTq

//@@MCP 2510 PRSEG
// <GROUP !!CONSTANTS>
// Description
//		Propagation segment length
//
#define PRSEG_8TQ       0x07	//@@ <GROUP MCP 2510 PRSEG> 8xTq 
#define PRSEG_7TQ       0x06	//@@ <GROUP MCP 2510 PRSEG> 7xTq 
#define PRSEG_6TQ       0x05	//@@ <GROUP MCP 2510 PRSEG> 6xTq 
#define PRSEG_5TQ       0x04	//@@ <GROUP MCP 2510 PRSEG> 5xTq 
#define PRSEG_4TQ       0x03	//@@ <GROUP MCP 2510 PRSEG> 4xTq 
#define PRSEG_3TQ       0x02	//@@ <GROUP MCP 2510 PRSEG> 3xTq 
#define PRSEG_2TQ       0x01	//@@ <GROUP MCP 2510 PRSEG> 2Tq 
#define PRSEG_1TQ       0x00	//@@ <GROUP MCP 2510 PRSEG> 1xTq 

//@@MCP 2510 PHSEG2
// <GROUP !!CONSTANTS>
// Description
//		Phase segment 2 length
//
#define PHSEG2_8TQ      0x07	//@@ <GROUP MCP 2510 PHSEG2> 8xTq 
#define PHSEG2_7TQ      0x06	//@@ <GROUP MCP 2510 PHSEG2> 7xTq 
#define PHSEG2_6TQ      0x05	//@@ <GROUP MCP 2510 PHSEG2> 6xTq 
#define PHSEG2_5TQ      0x04	//@@ <GROUP MCP 2510 PHSEG2> 5xTq 
#define PHSEG2_4TQ      0x03	//@@ <GROUP MCP 2510 PHSEG2> 4xTq 
#define PHSEG2_3TQ      0x02	//@@ <GROUP MCP 2510 PHSEG2> 3xTq 
#define PHSEG2_2TQ      0x01	//@@ <GROUP MCP 2510 PHSEG2> 2xTq 
#define PHSEG2_1TQ      0x00	//@@ <GROUP MCP 2510 PHSEG2> 1xTq 

//@@MCP 2510 WAKFIL
// <GROUP !!CONSTANTS>
// Description
//		Wake-up 
//
#define WAKFIL_ENABLED  0x40	//@@ <GROUP MCP 2510 WAKFIL> Enable
#define WAKFIL_DISABLED 0x00	//@@ <GROUP MCP 2510 WAKFIL> Disable

//@@MCP 2510 SPI
// <GROUP !!CONSTANTS>
// Description
//		SPI commands 
//
#define MCP2510_RESET	192		//@@ <GROUP MCP 2510 SPI> Reset command
#define MCP2510_READ	3		//@@ <GROUP MCP 2510 SPI> Read command
#define MCP2510_WRITE	2		//@@ <GROUP MCP 2510 SPI> Write command
#define MCP2510_RTS		128		//@@ <GROUP MCP 2510 SPI> Request to send command

#define MCP2510_STATUS	160		//@@ <GROUP MCP 2510 SPI> Read status command
#define MCP2510_BITMOD	5		//@@ <GROUP MCP 2510 SPI> Bitmod command


#endif // _MCP2510_registerS_H_
