#ifndef _BIT_BASE_H_
#define _BIT_BASE_H_

//@@ Description
//		Sets a given bit to one.
#define hw_bitset(var,bitno) ((var)|=1<<(bitno))

//@@ Description
//		Sets a given bit to zero.
#define hw_bitclr(var,bitno) ((var)&=~(1<<(bitno)))

//@@ Description
//		Tests a given bit for one.
#define hw_bitest(var,bitno) (((var)>>(bitno))&0x01) 

//@@ Description
//		Tests a given bit for one.
#define hw_bittest(var,bitno) (bitest(var,bitno))


#endif // _BIT_BASE_H_
