// ex03_fabiaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ex03_fabia.h"
#include "ex03_fabiaDlg.h"
#include "pp2can_lib.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TACHO_BITMAP_X 765
#define TACHO_BITMAP_Y 316

#define TACHO_REV_COUNTER_ZERO 135
#define TACHO_REV_COUNTER_X 165
#define TACHO_REV_COUNTER_Y 186	

#define TACHO_SPEED_ZERO 136
#define TACHO_SPEED_X 597
#define TACHO_SPEED_Y 186	

#define TACHO_ENGINE_ZERO 215
#define TACHO_ENGINE_X 325
#define TACHO_ENGINE_Y 85

#define TACHO_FUEL_ZERO 215
#define TACHO_FUEL_X 440
#define TACHO_FUEL_Y 85	

	unsigned char filter_0[4] = {106,32,0,0}; 
	unsigned char filter_1[4] = {106,96,0,0}; 
	unsigned char filter_2[4] = {106,32,0,0}; 
	unsigned char filter_3[4] = {106,96,0,0}; 
	unsigned char filter_4[4] = {110,32,0,0}; 
	unsigned char filter_5[4] = {198,160,0,0}; 

	unsigned char mask_0[4] = {255,224,0,0}; 
	unsigned char mask_1[4] = {255,224,0,0}; 


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEx03_fabiaDlg dialog

CEx03_fabiaDlg::CEx03_fabiaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEx03_fabiaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEx03_fabiaDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	rev_counter = 0;
	speed = 0;
	engine_temperature = 0;
	fuel = 0;

	door = false;
	lights = false;
}

void CEx03_fabiaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEx03_fabiaDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEx03_fabiaDlg, CDialog)
	//{{AFX_MSG_MAP(CEx03_fabiaDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEx03_fabiaDlg message handlers

BOOL CEx03_fabiaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	hpicture_on = (HBITMAP)::LoadImage(NULL, "fabia_on.bmp", IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
	hpicture_off = (HBITMAP)::LoadImage(NULL, "fabia_off.bmp", IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);

	SetPriorityClass(GetCurrentProcess(),HIGH_PRIORITY_CLASS);

	PP2CAN_Open(0x378, SPEED_100k, NULL, NULL, 1, false, false);
	if(PP2CAN_init_ok)
	{
		MessageBox("PP2CAN OK");
		//P2CAN_SET_LOOPBACK_MODE();
		PP2CAN_SET_FILTER_FILTER(0, &filter_0[0]);
		PP2CAN_SET_FILTER_FILTER(1, &filter_1[0]);
		PP2CAN_SET_FILTER_FILTER(2, &filter_2[0]);
		PP2CAN_SET_FILTER_FILTER(3, &filter_3[0]);
		PP2CAN_SET_FILTER_FILTER(4, &filter_4[0]);
		PP2CAN_SET_FILTER_FILTER(5, &filter_5[0]);

		PP2CAN_SET_FILTER_MASK(0, &mask_0[0]);
		PP2CAN_SET_FILTER_MASK(1, &mask_1[0]);
	}
	else
		MessageBox("PP2CAN ERROR");
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CEx03_fabiaDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CEx03_fabiaDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CPaintDC dc(this); // device context for painting
		reload_bitmap(&dc);
		paint_bitmap(&dc);
	//	CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CEx03_fabiaDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CEx03_fabiaDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CEx03_fabiaDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CEx03_fabiaDlg::reload_bitmap(CDC *dc)
{
	CDC dc_mem, dc_picture, dc_on;
	if( hpicture_on == NULL || hpicture_off == NULL) {
		dc_mem.CreateCompatibleDC(dc);
		CBitmap *old_bitmap = dc_mem.SelectObject(bmap);

		// Vyplneni podkladem misto obrazkem
		CBrush brush;
		brush.CreateSolidBrush(RGB(0, 0, 0));
	    dc_mem.SelectObject(brush);
	    dc_mem.Rectangle(0, 0, TACHO_BITMAP_X - 1, TACHO_BITMAP_Y - 1);
	   	brush.DeleteObject();

		dc_mem.SelectObject(old_bitmap);
		return;
	}

	// Vytvoreni CBitmap z windowsovskeho handlu HBITMAP
	CBitmap *picture_off = CBitmap::FromHandle(hpicture_off);
	CBitmap *picture_on = CBitmap::FromHandle(hpicture_on);

	// Vytvoreni kompatibilniho DC pro kresleni do bitmapy
	dc_picture.CreateCompatibleDC(dc);
	CBitmap *old_picture = dc_picture.SelectObject(picture_off);

	dc_on.CreateCompatibleDC(dc);
	dc_on.SelectObject(picture_on);

	dc_mem.CreateCompatibleDC(dc);
	CBitmap *old_bitmap = dc_mem.SelectObject(bmap);

	// Kopie obrazku budiku do vykreslovane bitmapy
	dc_mem.BitBlt(0, 0, TACHO_BITMAP_X, TACHO_BITMAP_Y, &dc_picture, 0, 0, SRCCOPY);

	//////////////////////////////////////////////////////////////////
	// Dvere
	if(door==true)
		dc_mem.BitBlt(326,187,30,25,&dc_on,326,187, SRCCOPY);

	// Svetla
	if(lights==true)
		dc_mem.BitBlt(368,21,30,23,&dc_on,368,21, SRCCOPY);

	//////////////////////////////////////////////////////////////////

	dc_picture.SelectObject(old_picture);
	dc_mem.SelectObject(old_bitmap);
}


void CEx03_fabiaDlg::paint_bitmap(CDC *dc)
{

	CPen pen;
	LOGBRUSH logbrush;
	CBrush brush;

	// Vytvoreni kompatibilniho DC pro kresleni do bitmapy
	CDC dc_mem;
	dc_mem.CreateCompatibleDC(dc);
	CBitmap *old_bitmap = dc_mem.SelectObject(bmap);

	// Vykresleni raficky budiku
	brush.CreateSolidBrush(RGB(240, 240, 240));
	dc_mem.SelectObject(brush);

	// Otackomer
	double rev_counter2 = (double)(rev_counter/10000.0f)*-360.0f;
	pen.CreatePen(PS_SOLID, 4, RGB(240, 240, 240));
	dc_mem.SelectObject(pen);
	dc_mem.MoveTo(TACHO_REV_COUNTER_X, TACHO_REV_COUNTER_Y);
	dc_mem.AngleArc(TACHO_REV_COUNTER_X, TACHO_REV_COUNTER_Y, 110, float(rev_counter2-TACHO_REV_COUNTER_ZERO), 0);
	pen.DeleteObject();

	pen.CreatePen(PS_SOLID, 4, RGB(240, 240, 240));
	dc_mem.SelectObject(pen);
	dc_mem.MoveTo(TACHO_REV_COUNTER_X, TACHO_REV_COUNTER_Y);
	dc_mem.AngleArc(TACHO_REV_COUNTER_X, TACHO_REV_COUNTER_Y, 25, float(rev_counter2-TACHO_REV_COUNTER_ZERO-180), 0);
	pen.DeleteObject();

	// Rychlomer
	double speed2 = (double)(speed/293.0f)*-360.0f;
	pen.CreatePen(PS_SOLID, 4, RGB(240, 240, 240));
	dc_mem.SelectObject(pen);
	dc_mem.MoveTo(TACHO_SPEED_X, TACHO_SPEED_Y);
	dc_mem.AngleArc(TACHO_SPEED_X, TACHO_SPEED_Y, 110, float(speed2-TACHO_SPEED_ZERO), 0);
	pen.DeleteObject();

	pen.CreatePen(PS_SOLID, 4, RGB(240, 240, 240));
	dc_mem.SelectObject(pen);
	dc_mem.MoveTo(TACHO_SPEED_X, TACHO_SPEED_Y);
	dc_mem.AngleArc(TACHO_SPEED_X, TACHO_SPEED_Y, 25, float(speed2-TACHO_SPEED_ZERO-180), 0);
	pen.DeleteObject();

	// engine_temperature
	double engine_temperature2 = (double)(engine_temperature/590.0f)*-360.0f;
	pen.CreatePen(PS_SOLID, 4, RGB(240, 240, 240));
	dc_mem.SelectObject(pen);
	dc_mem.MoveTo(TACHO_ENGINE_X, TACHO_ENGINE_Y);
	dc_mem.AngleArc(TACHO_ENGINE_X, TACHO_ENGINE_Y, 50, float(engine_temperature2-TACHO_ENGINE_ZERO), 0);
	pen.DeleteObject();

	pen.CreatePen(PS_SOLID, 4, RGB(240, 240, 240));
	dc_mem.SelectObject(pen);
	dc_mem.MoveTo(TACHO_ENGINE_X, TACHO_ENGINE_Y);
	dc_mem.AngleArc(TACHO_ENGINE_X, TACHO_ENGINE_Y, 10, float(engine_temperature2-TACHO_ENGINE_ZERO-180), 0);
	pen.DeleteObject();

	// fuel
	double fuel2 = (double)(fuel/590.0f)*-360.0f;
	pen.CreatePen(PS_SOLID, 4, RGB(240, 240, 240));
	dc_mem.SelectObject(pen);
	dc_mem.MoveTo(TACHO_FUEL_X, TACHO_FUEL_Y);
	dc_mem.AngleArc(TACHO_FUEL_X, TACHO_FUEL_Y, 50, float(fuel2-TACHO_FUEL_ZERO), 0);
	pen.DeleteObject();

	pen.CreatePen(PS_SOLID, 4, RGB(240, 240, 240));
	dc_mem.SelectObject(pen);
	dc_mem.MoveTo(TACHO_FUEL_X, TACHO_FUEL_Y);
	dc_mem.AngleArc(TACHO_FUEL_X, TACHO_FUEL_Y, 10, float(fuel2-TACHO_FUEL_ZERO-180), 0);
	pen.DeleteObject();

	// Kopie bitmapy na obrazovku
	dc->BitBlt(5, 6, TACHO_BITMAP_X, TACHO_BITMAP_Y, &dc_mem, 0, 0, SRCCOPY);
	dc_mem.SelectObject(old_bitmap);
}

int CEx03_fabiaDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	bmap = new CBitmap;
	CDC *dc = GetDC();
	bmap->CreateCompatibleBitmap(dc, TACHO_BITMAP_X, TACHO_BITMAP_Y);
	ReleaseDC(dc);
	
	SetTimer(1,40,NULL);	
	SetTimer(2,60,NULL);	
	return 0;
}

void CEx03_fabiaDlg::OnClose() 
{
	KillTimer(1);	
	KillTimer(2);
	PP2CAN_Close();
	
	CDialog::OnClose();
}

void CEx03_fabiaDlg::OnTimer(UINT nIDEvent) 
{
	MCP2510Msg *data =NULL;
	unsigned __int16 Id1;
	unsigned __int32 Id2;
	bool rtr;
	bool st_ext;
	unsigned char length;
	unsigned __int16 *pi16;
/*
	static bool d1 = false;
	static bool d2 = false;
	if(d1==false)
	{
		door = false;
		rev_counter+=100;
		if(rev_counter==6000) d1 = true;
	}
	else
	{
		door = true;
		rev_counter-=100;
		if(rev_counter==0) d1 = false;
	}
	if(d2==false)
	{
		lights = true;
		speed+=1;
		if(speed==200) d2 = true;
	}
	else
	{
		lights = false;
		speed-=1;
		if(speed==0) d2 = false;
	}
*/
/*
	MCP2510Msg msg;
	PP2CAN_MSG_set_ID2(&msg.bytes[0], 851);
	PP2CAN_MSG_set_DLC1(&msg.bytes[0], false, 8);

	msg.item.data[0] = 0;
	msg.item.data[1] = 200;
	msg.item.data[2] = s;
	msg.item.data[3] = 0;
	msg.item.data[4] = 0;
	msg.item.data[5] = 0;
	msg.item.data[6] = 0;
	msg.item.data[7] = 0;
	
	PP2CAN_SEND(msg);
	*/

	if(nIDEvent==1)
	{
		while(PP2CAN_GET_LENGTH()>0)
		{
		    if(PP2CAN_GET(&data))
			{
				st_ext = PP2CAN_MSG_get_ID1(&data->bytes[0],Id1,Id2);
		        if(st_ext==false)	
				{
					PP2CAN_MSG_get_DLC2(&data->bytes[0],rtr,length);
					switch(Id1)
					{
					case 851:
						pi16 = (unsigned __int16*)&data->item.data[1];
						rev_counter = *pi16;
						rev_counter/=4;
						engine_temperature = data->item.data[3]/2;
						break;
					case 849:
						pi16 = (unsigned __int16*)&data->item.data[1];
						speed = *pi16;
						speed/=185;
						break;
					case 881:
						if((data->item.data[0]&0x0F)>0)
							door = true;
						else
							door = false;
						break;
					case 1589:
						if(data->item.data[0]>0)
							lights = true;
						else
							lights = false;
						break;
					default:
						break;
					}
				}

				PP2CAN_DELETE(data);
				//delete data;
			}
		}
	}
	else if(nIDEvent==2)
	{
		CDC *dc = GetDC();
		reload_bitmap(dc);
		paint_bitmap(dc);	
		ReleaseDC(dc);	
	}
	CDialog::OnTimer(nIDEvent);
}
